#!/bin/bash
#jason
#20220618
#替换tomcat包
date=`date +%F_%H-%M-%S` 
bak_dir="/usr/local/geekplus/backup/tomcatbak-$date"

python /usr/local/geekplus/script_tools/tomcat_manager.py init
python /usr/local/geekplus/script_tools/tomcat_manager.py stop all 
##备份
if [ ! -d $bak_dir ];then
	mkdir -p $bak_dir
fi
mv /usr/local/geekplus/tomcat-* $bak_dir/

###替换tomcat
if [ ! -f /usr/local/geekplus/script_tools/tomcat_list.conf ];then
	echo "tomcat list file no exist"
	exit 1
fi
for i in `cat /usr/local/geekplus/script_tools/tomcat_list.conf | grep -v "temp$"`;
do
	cp -r ./tomcat /usr/local/geekplus/$i
	[ -f /usr/local/geekplus/$i/bin/catalina.sh ] && rm -rf /usr/local/geekplus/$i/bin/catalina.sh
	[ -f /usr/local/geekplus/$i/conf/server.xml ]  && rm -rf /usr/local/geekplus/$i/conf/server.xml
	[ -f $bak_dir/$i/bin/catalina.sh ] &&  cp  $bak_dir/$i/bin/catalina.sh /usr/local/geekplus/$i/bin/catalina.sh
	[ -f $bak_dir/$i/conf/server.xml ] && cp  $bak_dir/$i/conf/server.xml /usr/local/geekplus/$i/conf/server.xml
	[ -f $bak_dir/$i/bin/setenv.sh ] && cp  $bak_dir/$i/bin/setenv.sh /usr/local/geekplus/$i/bin/setenv.sh


	if [ -f /usr/local/geekplus/$i/conf/server.xml ];then
		num=`grep "relaxedPathChars" /usr/local/geekplus/$i/conf/server.xml |wc -l`
		if [ $num -eq 0 ];then
			sed -i '70a relaxedPathChars="[\]^`{|}"' /usr/local/geekplus/$i/conf/server.xml
			sed -i '70a relaxedQueryChars="[\]^`{|}"' /usr/local/geekplus/$i/conf/server.xml
			sed -i 's/\r//g' /usr/local/geekplus/$i/conf/server.xml
		fi
	fi
	cp -r $bak_dir/$i/webapps/* /usr/local/geekplus/$i/webapps/ > /dev/null 2>&1
	
done

python /usr/local/geekplus/script_tools/tomcat_manager.py restart all 



echo " "

for i in `cat /usr/local/geekplus/script_tools/tomcat_list.conf | grep -v "temp$"`;
do	
	version=`bash /usr/local/geekplus/$i/bin/version.sh |grep "Server number:"|awk '{print$3}'`
	echo -e "$i : $version"
done

